/*------------------------------------------------------------------------------*
 *	File Name: 	OCTreeUtils.h							 						*
 *	Purpose:																   	*
 *  Creation:	07/07/2004, Shulin												*
 *				SY 07/07/2004 QA70-6641 MOVE_OC_TREE_UTILITY_TO_VC_LEVEL		*
 *  	Copyright Originlab Corp. 2003, 2004,									*
 *	Modification log	                                                        *
 *  SY 09/03/2004 v8.0119 OCTREE_ATTRIBUTE_VALUES_ASSERT_FALSE					*
 *	YuI 10/18/04 QA70-70-60 v7.5151 NON_HIERARCHY_GRID_SHOULD_NOT_ADD_UNWANTED_COLUMNS*
 *  Danice 12/1/04 QA70-6891 v8.0168 GET_TREENODE_STOP_ATTRIBUTE_OPTION			*
 *  DG 3/17/05 v8.0206 CLEAN_DOUBLE_STORAGE										*
 *  SY 03/25/2005 QA70-7543 v8.0212 OCTREE_FIND_NODE_BY_ATTRIBUTE				*
 *  Forest 3/30/05 QA70-7456 COPY_TREE_BY_FILTER								*
 *  Forest 4/2/05 TREE_FILTER_BY_ATTRIB_MATCH									*
 *  DG 4/18/05 v8.0223 REWRITE_TREE_GET_NODE									*
 *	ML 4/18/2005 XFUNCTION_TREE_MANIPULATION_IN_VC								*
 *	DSC 8/26/05 OCTREE_FIND_NODE_BY_ID_AND_REPEAT_ID							*
 *	DSC 9/26/05 QA70-8113 TEST_DATAID_EXITS_AND_VALID							*
 *	ML 1/13/2006 XVARIABLEBASE_TO_VC											*	  
 *  Hong 7/26/06 MOVE_OC_TO_VC													*
 *	ML 9/5/2006 NLFIT_GETTING_WEIGHT_TYPE_INFO									*
 *	ML 1/17/2007 PUTTING_TAGNAMES_PATH_INTO_ATTRIBUTES							*
 *	ML 2/14/2007 QA70-9374 BAD_EVENT_HANDLER_DWORDS_IN_TREENODES				*
 *	Cheney 2007-1-30 MOVE_SOME_FUNCTION_FOR_NLFIT_REPORT_TO_VC					*
 *	Cheney 2007-3-7 IMPROVE_SPEED_FOR_STATS_ON_COLUMNS							*
 *	YuI 03/15/07 SET_TREE_GET_TREE_DISCREPANCY_IN_MULTYXY_FITTING				*
 *	AW 04/03/07 QA80-9548 v8.0597 XF_LOCALIZATION								*
 *	TD 5-4-07 QA80-9724 THEME_TREE_WITH_LABELS_FOR_READABILITY					*
 *  SY 2007-06-07 QA70-9882 v8.0635 IMPROVE_TREE_COPY_VALUES_BY_ID				*
 *	Hong 06/18/07 v8.0643 FIX_XF_SHOW_HELP_BY_LT_ERROR_SHOW_HIDDEN_NODE			*
 *	Hong 06/26/07 v8.0649 TREE_GET_ROW_NUMBER_IN_SPLITTER						*
 *	Folger 07/27/07 UPDATE_USAGE_OF_OCTREE_THEME_TREE_GET_NODE_BY_INDEX			*
 *	Hong 08/01/07 v8.0672 THEME_FILE_ALLOW_NOT_SAVE_UNCHANGE_NODE				*
 *	EJP 2007-08-09 v8.0768 QA70-10171 FIX_IMG_MISSING_IN_IMG_PREVIEW_DLG		*
 *	RVD 10/4/2007 v8.0715 qa7-10463 FIX_NLFIT_LIMIT_20_PARAMETERS				*
 *	Hong 10/17/07 v8.0727b JASMINE_ASK_FOR_INT_ARRAY							*
 *	Sim 11-13-2007 GET_CREATED_OUTPUT_PAGE_INFO									*
 *	ML 11/20/2007 QA70-10716 INPUT_DATA_NODE_PROPER_LANGUAGE_WHEN_LOADING_OPER	*
 *	ML 12/7/2007 QA70-10780 MORE_DEBUGGING_REPORT_FILTERING						*
 *	Folger 12/28/07 TREE_TAGNAME_OPERATION_MOVE_TO_VC							*
 *	Hong 01/17/08 QA80-10937 FIX_THEME_APPLY_SHOULD_DUPLIACTE_LAST_DATASET		*
 *	Folger 03/03/08 QA80-11192 LOAD_DEFAULT_THEME_BEFORE_RESET_TO_FACTORY_DEFAULT
 *	Folger 03/19/08 QA80-10598 SUPPORT_COPY_VALUE_FROM_ONE_ATTRIBUTE_TO_ANOTHER	*
 *	ML 4/25/2008 NL_SURFACE_FIT_INPUT_DATA_TABLE_WITH_WEIGHTS					*
 *	Folger 12/08/08 v8.0983b CHECK_GET_NODE_SHOULD_SUPPORT_CASE_INSENSITIVE		*
 *	YuI 12/18/08 QA70-12800 PD_DIALOG_TO_CONTROL_HISTOGRAM_CREATED_BY_OPERATION	*
 *	TD 01-08-2009 QA80-12937 LT_DRIVEN_XFUNCTIONS								*
 *	YuI 03/05/09 QA70-13220 WHOLE_WORKSHEET_INPUT_XYRANGE						*
 *	Folger 03/18/09 QA80-13261-P2 NEW_ADDED_AUTO_FOR_XF_VARIABLE_FAILS_TO_COMPATIBLE_WITH_OLD_THEME
 *	Folger 03/24/09 QA80-13331-P1 CUSTOMIZED_OUTPUT_COLUMN_LONGNAME_FORMAT_SUPPORT
 *	YuI 03/23/09 QA70-12160 XYRANGE_XERROR_SUPPORT								*
 *	Kyle 04/09/2009 QA80-13425 WANT_REPORTDATA_SUPPORT_USING_DEFAULT_ENUMERATION_FOR_SHORTNAME
 *	Folger 04/15/09 QA80-13454 SPECIAL_ATTRIBUTES_SHOULD_BE_CORRECTLY_UPDATED_WHEN_USE_OLD_THEME_AND_OP
 *  Iris 8/31/2009 QA80-14209 IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED	*
 *	Folger 09/11/09 COPY_VALUES_BY_IDS_SUPPORT_SKIP_EMPTY_VALUES				*
 *	Hong 12/11/09 QA80-14138-P2 FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
 *	Folger 08/17/10 ORG-824-P1 WEIGHTING_BROKEN_FOR_MULTIPLE_DEPS_FITTING		*
 *	Sophy 10/25/2010 ORG-1296 MOVE_BUILDDBTREE_TO_VC_FOR_SPEEDUP_NEW_DATABASEIMPORT_DLG
 *------------------------------------------------------------------------------*/      

#ifndef _OCTREEUTILS_H
#define _OCTREEUTILS_H


#ifdef __AFX_H__
	/// ML 4/18/2005 XFUNCTION_TREE_MANIPULATION_IN_VC
	//#ifdef OCTREE_UTILS_DLL
	//	#define OC_API __declspec(dllexport)
	//#else
	//	#define OC_API __declspec(dllimport)
	//#endif
	//
	///---------- SY 03/23/2005	move from tree_utils.h
	#ifdef _DEBUG
		#define CHECK_IF_ID_DUPLICATE	///Forest 09/11/04 QA70-6682 CHECKING_IF_ID_DUPLICATE
	#endif
	//-----------

	// Without commenting I replace in the entire DLL OC_API with OCTRUT_API 
	#ifdef OCTREE_UTILS_DLL
		#define OCTRUT_API __declspec(dllexport)
	#else
		#define OCTRUT_API __declspec(dllimport)
	#endif
	/// end XFUNCTION_TREE_MANIPULATION_IN_VC

	/*
	#define string 			CString  //DSC 9/26/05 QA70-8113 TEST_DATAID_EXITS_AND_VALID
	#define TreeNode		OCXmlWrapperBase
	#define StringArray		CScriptMocaObject
	#define	IntArray		CScriptMocaObject
	*/
	#include "OCtoVC.h"
	#include "DataIDs.h"	 /// AW 04/03/07 QA80-9548 v8.0597 XF_LOCALIZATION
	/// YuI 12/21/07 QA7-10854 MOVE_HISTOGRAM_TO_VC
	#include ".\..\ocMath\stats_types.h"
	/// end MOVE_HISTOGRAM_TO_VC
	extern "C" {
#else
	/// ML 4/18/2005 XFUNCTION_TREE_MANIPULATION_IN_VC
	//#define OC_API
	#define OCTRUT_API
	/// end XFUNCTION_TREE_MANIPULATION_IN_VC
	#pragma dll(OCTree_Utils)	// Associate all functions below to OCTree_Utils.dll which must be in the Origin EXE folder
	#define	IntArray	vector<int>
	/// RVD 10/4/2007 v8.0715 qa7-10463 FIX_NLFIT_LIMIT_20_PARAMETERS
	#define	BoolArray		vector<bool>
	#define	DoubleArray		vector<double>
	/// end FIX_NLFIT_LIMIT_20_PARAMETERS
	/// YuI 12/21/07 QA7-10854 MOVE_HISTOGRAM_TO_VC
	#include <stats_types.h>
	/// end MOVE_HISTOGRAM_TO_VC
#endif	//__AFX_H__




//#define MAX_REPEAT_ID_VALUE		1000			
#define MAX_REPEAT_ID_VALUE		0x7fff		///Frank 4/2/05  REPEATID_SHOULD_ENLARGE
#define INVALID_TREENODE_DATAID	-1

/// ML 4/18/2005 XFUNCTION_TREE_MANIPULATION_IN_VC
//#define	STR_REPEAT_ID_ATTRIB		"RepeatID"   ///Iris 03/02/05 QA70-7455
/// end XFUNCTION_TREE_MANIPULATION_IN_VC
#define STR_THEME_TYPE_ATTRIB		"ThemeType"	 ///Iris 03/07/05 QA70-7345 ADD_FB_FILTER_THEME
///---------- 

///Forest 3/30/05 QA70-7456 COPY_TREE_BY_FILTER
enum
{
	TCF_INCLUDE_ALL,//include if all in vsIncludeValues found
	TCF_INCLUDE_ANY,//include if any in vsIncludeValues found
};

enum
{
	TCF_EXCLUDE_ALL_NOT_INCLUDE, // vsExcludeValues is ignore
	TCF_EXCLUDE_ANY,// exclude if any in vsExcludeValues found
	TCF_EXCLUDE_ALL,// exclude only if all in vsExcludeValues found
};
///End COPY_TREE_BY_FILTER

#define	COMPLEX_SUBRANGE_BASE_NAME		"Range"

OCTRUT_API BOOL octree_copy_values_to_attributes_by_attribute_matching(TreeNode* ptrSrc, TreeNode* ptrDest, 
																   LPCSTR lpcszDestAttribute=NULL, LPCSTR lpcszAttributeToMatch=NULL,
																   LPCSTR lpcsz2ndAttributeToTransfer = NULL,
																   BOOL bRecursive = true, BOOL bAllMatched = true, BOOL bCaseSensitive = false);

//OC_API BOOL octree_get_node(TreeNode* ptrRoot, TreeNode* ptrReturnNode, int nRow, int nStopLevel = -1, int nStartLevel = 0, int* lpInc = NULL);///Danice GET_TREENODE_STOP_ATTRIBUTE_OPTION
//OC_API BOOL octree_get_node(TreeNode* ptrRoot, TreeNode* ptrReturnNode, int nRow, int nStopLevel = -1, bool bCheckSkipSubTreeAttrib=false, LPCSTR lpcstrStopAttribute=NULL, int nStartLevel = 0, int* lpInc = NULL);	///DG CLEAN_DOUBLE_STORAGE
//OC_API BOOL octree_get_node(TreeNode* ptrRoot, TreeNode* ptrReturnNode, int nRow, int nStopLevel = -1, LPCSTR lpcszSkipSubTreeAttrib=NULL, int nStartLevel = 0, int* lpInc = NULL);	///DG 3/18/05 CLEAN_DOUBLE_STORAGE
//OC_API BOOL octree_get_node(TreeNode* ptrRoot, TreeNode* ptrReturnNode, int nRow, int nStopLevel=-1, LPCSTR lpcszStopAttribute = NULL, bool bStopAtLastBranch = false, int nCurrentLevel = 0, int* lpInc = NULL);	///DG REWRITE_TREE_GET_NODE
OCTRUT_API BOOL octree_get_node(TreeNode* ptrRoot, TreeNode* ptrReturnNode, int nRow, 
							int *pnCurrentRow, int nStopLevel=-1, LPCSTR lpcszAttribute = NULL, 
							bool bUseAttributeAsStop = true, bool bSkipLeaf = false, int nCurrentLevel=0);
/// AW 01/29/07 QA80-9310 v8.0550b AUTO_RECOGNITION_FOR_INDEX_RAW_DATA_IN_STATS_TOOL
OCTRUT_API BOOL octree_get_node_ex(TreeNode* ptrRoot, TreeNode* ptrRet, int nRow, DWORD dwCntrl = 0, LPCSTR lpcszAttribute = NULL);
/// END AUTO_RECOGNITION_FOR_INDEX_RAW_DATA_IN_STATS_TOOL


/// ------  AW 10/02/06 QA80-9015 v8.0493 MORE_ON_LOAD_THEME_IN_IMPORT
//enum {TREE_COPY_SKIP_HIDDEN = 0x0001, TREE_COPY_ATTRIB_ENABLE = 0x0002};

/// YuI 03/27/07 PROPER_DISCONTIGUOS_SELECTION_INITIALIZATION
/*
/// YuI 03/15/07 SET_TREE_GET_TREE_DISCREPANCY_IN_MULTYXY_FITTING
//	enum {TREE_COPY_SKIP_HIDDEN = 0x0001, TREE_COPY_ATTRIB_ENABLE = 0x0002, TREE_COPY_SKIP_NONDATAID = 0x0004};
enum{
	TREE_COPY_SKIP_HIDDEN						= 0x0001, 
	TREE_COPY_ATTRIB_ENABLE						= 0x0002, 
	TREE_COPY_SKIP_NONDATAID					= 0x0004,
	TREE_COPY_BY_NAME_AND_ORDER					= 0x0008,
};
/// end SET_TREE_GET_TREE_DISCREPANCY_IN_MULTYXY_FITTING
*/
/// end PROPER_DISCONTIGUOS_SELECTION_INITIALIZATION
/// ------  END MORE_ON_LOAD_THEME_IN_IMPORT

/// YuI 03/27/07 PROPER_DISCONTIGUOS_SELECTION_INITIALIZATION
// moving this function to okUtil.dll
//	OCTRUT_API int octree_copy_values(TreeNode* ptrSrc, TreeNode* ptrDest, WORD wOptions = TREE_COPY_SKIP_HIDDEN | TREE_COPY_ATTRIB_ENABLE);
/// end PROPER_DISCONTIGUOS_SELECTION_INITIALIZATION

/// YuI 03/15/07 SET_TREE_GET_TREE_DISCREPANCY_IN_MULTYXY_FITTING
OCTRUT_API int octree_copy_values_between_homologous_trees(TreeNode* ptrDest, TreeNode* ptrSrc,  BOOL bCoptyAttribues = TRUE);
/// end SET_TREE_GET_TREE_DISCREPANCY_IN_MULTYXY_FITTING

//----------- SY 07/30/2004 per CP's request, centralize octree_get_shows and octree_get_enables to octree_get_attributes
///OC_API int octree_get_shows(TreeNode* ptr, IntArray* pocia, int nSetShow = -1);
//----------- 

OCTRUT_API int octree_get_values(TreeNode* ptr, StringArray* pocsa, bool bSubNodeOnly=false);	///Danice 12/15/04 : add get subnode only argument

OCTRUT_API int octree_get_attributes(TreeNode* ptr, StringArray* pocsa, LPCSTR lpcszAttribute, bool bSubNodeOnly=false);	///Danice 12/15/04 : add get subnode only argument

OCTRUT_API int octree_update_changes(TreeNode* ptr, StringArray* pocsa);

OCTRUT_API BOOL octree_node_changed(TreeNode* ptrNode, BOOL bSet = FALSE, LPCSTR lpcszOldValue = NULL);

//----------- SY 07/30/2004 per CP's request, centralize octree_get_shows and octree_get_enables to octree_get_attributes
///OC_API int octree_get_enables(TreeNode* ptr, IntArray* pocia, int nSetEnable = -1);
/// SY 09/03/2004 v8.0119 OCTREE_ATTRIBUTE_VALUES_ASSERT_FALSE
///OC_API int octree_attribute_values(TreeNode* ptr, LPCSTR lpcszAttribute, int nSetAll, IntArray* pocia = NULL);
OCTRUT_API int octree_attribute_values(TreeNode* ptr, LPCSTR lpcszAttribute, int nSetAll, IntArray* pocia = NULL, BOOL bNoNegativeVal = true);
/// end OCTREE_ATTRIBUTE_VALUES_ASSERT_FALSE
//----------- 

OCTRUT_API BOOL oc_is_same(IntArray* pocv1, IntArray* pocv2);

OCTRUT_API int ocget_changed(StringArray* pocsa1, StringArray* pocsa2, bool bCaseSensitive = true);

/// ML 12/7/2007 QA70-10780 MORE_DEBUGGING_REPORT_FILTERING
///// YuI 10/18/04 QA70-70-60 v7.5151 NON_HIERARCHY_GRID_SHOULD_NOT_ADD_UNWANTED_COLUMNS
//OCTRUT_API void octree_delete_nodes_by_attribute(TreeNode* ptr, LPCSTR lpcszAttribute, int nValue, BOOL bRecursive = TRUE);
///// end NON_HIERARCHY_GRID_SHOULD_NOT_ADD_UNWANTED_COLUMNS
/// Hong 12/11/09 QA80-14138-P2 FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
//OCTRUT_API	int	octree_delete_nodes_by_attribute(TreeNode* ptr, LPCSTR lpcszAttribute, int nValue, BOOL bRecursive = TRUE);
OCTRUT_API	int	octree_delete_nodes_by_attribute(TreeNode* ptr, LPCSTR lpcszAttribute, int nValue, BOOL bRecursive = TRUE, LPCSTR lpcszAttribReserved = NULL);
/// end FIX_STATS_ON_COL_CHANGE_PARAM_CANNOT_ADD_BACK_MISSING_TABLE
/// end MORE_DEBUGGING_REPORT_FILTERING

//---- CPY 8/1/05 ADD_ID_OPTIONAL_TO_OTHER_ATTRIBUTES
// return number of nodes removed
/// Hong 06/11/10 ORG-131-P8 FIX_THEME_INDEX_ERROR_IN_MAT_DIM_DLG
//OCTRUT_API int octree_delete_nodes_by_missing_attribute(TreeNode* ptr, LPCSTR lpcszAttribute, BOOL bRecursive = true, BOOL bRemoveAttrib = true);
OCTRUT_API int octree_delete_nodes_by_missing_attribute(TreeNode* ptr, LPCSTR lpcszAttribute, BOOL bRecursive = true, BOOL bRemoveAttrib = true, BOOL bKeepBranch = TRUE);
/// end FIX_THEME_INDEX_ERROR_IN_MAT_DIM_DLG
//----

/// DSC 3/3/06 v8.0372 REMOVE_NODES_AND_BRANCHS_WITH_NO_VALUES
// return number of non-empty nodes
OCTRUT_API int octree_remove_empty_child_nodes(TreeNode* ptr, bool bRecursive=true);
/// end REMOVE_NODES_AND_BRANCHS_WITH_NO_VALUES

///---------- SY 03/23/2005
/// TD 5-4-07 QA80-9724 THEME_TREE_WITH_LABELS_FOR_READABILITY
//OCTRUT_API int octree_get_values_with_ids(TreeNode* ptrSetting, IntArray* pocvnIDs, StringArray* pocvsValues, BOOL bIncludeSub = TRUE, BOOL bCheckChange = FALSE, int nRepeatBranchID = 0, LPCSTR lpcszDestAttribName = NULL, BOOL bAddNegOneWhenBranchNoUseAttrib = true, string* pstrError=NULL); // CPY 8/1/05 ADD_ID_OPTIONAL_TO_OTHER_ATTRIBUTES , ///DSC 9/26/05 QA70-8113 TEST_DATAID_EXITS_AND_VALID add pstrError
OCTRUT_API int octree_get_values_with_ids(TreeNode* ptrSetting, IntArray* pocvnIDs, StringArray* pocvsValues,  StringArray* pocvsLabels, BOOL bIncludeSub = TRUE, BOOL bCheckChange = FALSE, int nRepeatBranchID = 0, LPCSTR lpcszDestAttribName = NULL, BOOL bAddNegOneWhenBranchNoUseAttrib = true, string* pstrError=NULL); // CPY 8/1/05 ADD_ID_OPTIONAL_TO_OTHER_ATTRIBUTES , ///DSC 9/26/05 QA70-8113 TEST_DATAID_EXITS_AND_VALID add pstrError
/// end THEME_TREE_WITH_LABELS_FOR_READABILITY

//Frank 11/11/05 ADD_REPEAT_ID_COMBINE_ERROR_OUT								
//OCTRUT_API int octree_set_values_by_ids(TreeNode* ptrSetting, IntArray* pocvnIDs, StringArray* pocvsValues, int nRepeatBranchID = 0, int* pnDuplicateID = NULL, BOOL bSetChange = FALSE, LPCSTR lpcszDestAttribName = NULL); // CPY 8/1/05 ADD_ID_OPTIONAL_TO_OTHER_ATTRIBUTES
///------ Folger 03/18/09 QA80-13261-P2 NEW_ADDED_AUTO_FOR_XF_VARIABLE_FAILS_TO_COMPATIBLE_WITH_OLD_THEME
//OCTRUT_API int octree_set_values_by_ids(TreeNode* ptrSetting, IntArray* pocvnIDs, StringArray* pocvsValues, int nRepeatBranchID = 0, int* pnDuplicateID = NULL, BOOL bSetChange = FALSE, LPCSTR lpcszDestAttribName = NULL, string* pstrError = NULL); // Frank 11/11/05 ADD_REPEAT_ID_ERROR_OUT
///------ Folger 04/15/09 QA80-13454 SPECIAL_ATTRIBUTES_SHOULD_BE_CORRECTLY_UPDATED_WHEN_USE_OLD_THEME_AND_OP
//OCTRUT_API int octree_set_values_by_ids(TreeNode* ptrSetting, IntArray* pocvnIDs, StringArray* pocvsValues, int nRepeatBranchID = 0, int* pnDuplicateID = NULL, BOOL bSetChange = FALSE, LPCSTR lpcszDestAttribName = NULL, string* pstrError = NULL, BOOL bResetAutoIfNeeded = FALSE);
enum
{
	SETVALUESBYIDS_RESET_AUTO_IF_NEEDED						= 0x00010000,
	SETVALUESBYIDS_ENABLE_DYNAUSECHECK_IF_NEEDED			= 0x00020000,
};
OCTRUT_API int octree_set_values_by_ids(TreeNode* ptrSetting, IntArray* pocvnIDs, StringArray* pocvsValues, int nRepeatBranchID = 0, int* pnDuplicateID = NULL, BOOL bSetChange = FALSE, LPCSTR lpcszDestAttribName = NULL, string* pstrError = NULL, DWORD dwCntrl = 0);
///------ End SPECIAL_ATTRIBUTES_SHOULD_BE_CORRECTLY_UPDATED_WHEN_USE_OLD_THEME_AND_OP
///------ End NEW_ADDED_AUTO_FOR_XF_VARIABLE_FAILS_TO_COMPATIBLE_WITH_OLD_THEME
///---END GET_CREATED_OUTPUT_PAGE_INFO
//End ADD_REPEAT_ID_COMBINE_ERROR_OUT								

OCTRUT_API int octree_whole_copy_values_by_id(TreeNode* ptrSrc, TreeNode* ptrDest);	/// SY 2007-06-07 QA70-9882 v8.0635 IMPROVE_TREE_COPY_VALUES_BY_ID

///---Sim 11-13-2007 GET_CREATED_OUTPUT_PAGE_INFO
//OCTRUT_API int octree_copy_values_by_id(TreeNode* ptrSrc, TreeNode* ptrDest, BOOL bCheckChange = false, LPCSTR lpcszSrcAttribName = NULL, LPCSTR lpcszDestAttribName = NULL, BOOL bAddNegOneWhenBranchNoUseAttrib = true); // CPY 8/1/05 ADD_ID_OPTIONAL_TO_OTHER_ATTRIBUTES, added  bCheckChange lpcszSrcAttribName	and lpcszDestAttribName
///------ Folger 09/11/09 COPY_VALUES_BY_IDS_SUPPORT_SKIP_EMPTY_VALUES
//OCTRUT_API int octree_copy_values_by_id(TreeNode* ptrSrc, TreeNode* ptrDest, BOOL bCheckChange = false, LPCSTR lpcszSrcAttribName = NULL, LPCSTR lpcszDestAttribName = NULL, BOOL bAddNegOneWhenBranchNoUseAttrib = true, BOOL bIgnoreCheckPredefinedTypeOnly = false);
OCTRUT_API int octree_copy_values_by_id(TreeNode* ptrSrc, TreeNode* ptrDest, BOOL bCheckChange = false, LPCSTR lpcszSrcAttribName = NULL, LPCSTR lpcszDestAttribName = NULL, BOOL bAddNegOneWhenBranchNoUseAttrib = true, BOOL bIgnoreCheckPredefinedTypeOnly = false, BOOL bSkipEmptyValues = FALSE);
///------ End COPY_VALUES_BY_IDS_SUPPORT_SKIP_EMPTY_VALUES
///---END GET_CREATED_OUTPUT_PAGE_INFO
///----------
/// ML 2/14/2007 QA70-9374 BAD_EVENT_HANDLER_DWORDS_IN_TREENODES

//------ Folger 03/19/08 QA80-10598 SUPPORT_COPY_VALUE_FROM_ONE_ATTRIBUTE_TO_ANOTHER
//if bCopyOneToTwo == TRUE, copy values from lpcszAttOne to lpcszAttTwo
OCTRUT_API int octree_copy_atts_by_id(TreeNode* ptrSrc, TreeNode* ptrDest, LPCSTR lpcszAttOne, LPCSTR lpcszIDSrcAttribName = NULL, LPCSTR lpcszIDDestAttribName = NULL, LPCSTR lpcszAttTwo = NULL, BOOL bCopyOneToTwo = FALSE);
//------

/// end BAD_EVENT_HANDLER_DWORDS_IN_TREENODES
/// ML 11/20/2007 QA70-10716 INPUT_DATA_NODE_PROPER_LANGUAGE_WHEN_LOADING_OPER
// It copies the att. value assuming same structures of the source and the destination trees.
OCTRUT_API	int	octree_copy_atts(TreeNode* ptrSrc, TreeNode* ptrDest, LPCSTR lpcszAttribName, BOOL bSkipRoots = FALSE);
/// end INPUT_DATA_NODE_PROPER_LANGUAGE_WHEN_LOADING_OPER

/// Hong 08/01/07 v8.0672 THEME_FILE_ALLOW_NOT_SAVE_UNCHANGE_NODE
OCTRUT_API int octree_remove_unchange_nodes_by_id(TreeNode* ptrSrc, TreeNode* ptrDest, LPCSTR lpcszSrcAttribName = NULL, LPCSTR lpcszDestAttribName = NULL);
/// end THEME_FILE_ALLOW_NOT_SAVE_UNCHANGE_NODE

/// YuI 03/06/06 PLOT_NOTATION_FRO_XYRANGE_INITIALIZATION
typedef enum tagCOMPOSITERANGETYPE
{
	CRT_PLAIN = 1,
	CRT_XYERR,
	CRT_XYZ,
	CRT_COMPLEX,
	CRT_FITTER,
	CRT_WEIGHT,
	CRT_XYYERRXERR,/// YuI 03/23/09 QA70-12160 XYRANGE_XERROR_SUPPORT
}	COMPOSITERANGETYPE;

OCTRUT_API BOOL	octree_set_composite_subrange_values(TreeNode* trSubRange, LPCSTR lpcsz1, LPCSTR lpcsz2, LPCSTR lpcsz3, int nDesignation = CRT_XYERR);
//OCTRUT_API BOOL	octree_create_composite_range_node(TreeNode* trRangeNode, TreeNode* tr, LPCSTR lpcszName, LPCSTR lpcszLabel, int nNumData, int nDesignation = CRT_XYERR);
OCTRUT_API BOOL	octree_create_composite_range_node(TreeNode* trRangeNode, TreeNode* tr, LPCSTR lpcszName, LPCSTR lpcszLabel, int nNumData, int nDesignation = CRT_XYERR, LPCSTR lpcszVal = NULL);
/// end PLOT_NOTATION_FRO_XYRANGE_INITIALIZATION


/// YuI 05/26/06 NLSF_INPUT_DATA_EXPANDED_GUI
/// ML 9/5/2006 NLFIT_GETTING_WEIGHT_TYPE_INFO
OCTRUT_API BOOL	octree_fitter_get_weight_mth_info(int nMethod, string *pstrDisplay, BOOL *pbData = NULL, BOOL *pbA = NULL, BOOL *pbB = NULL, BOOL *pbC = NULL);
/// end NLFIT_GETTING_WEIGHT_TYPE_INFO
/// end NLSF_INPUT_DATA_EXPANDED_GUI

/// --------YuI 08/30/05
enum {
	RID_REPEAT_ID_INVALID	= -3,	// return -3 if repeatID found is not in valid range
	RID_REPEAT_ID_CONFLICT	= -2,// return -2 if repeatID found is in conflict with nParentRepeatID
	RID_NODE_CONFLICT		= -1,// return -1 if tree node ID not compatible with repeat ID
	RID_NO_ID_CHANGE		= 0, // return 0 if no change to ID
	RID_REPEAT_ID_UPDATED, // return 1 if repeat ID is updated, but ID not changed
	RID_REPEAT_ID_UPDATED_ADD_PARENT,	// combining with parent repeat ID
	RID_ID_UPDATED, // return 2 if ID updated by combining with parent repeat id
};
OCTRUT_API int octree_combine_treenode_id_with_repeat_id(TreeNode* ptrSetting, int* pnID, int* pnRepeatBranchID, int nParentRepeatID); 
/// --------end YuI

/// SY 03/25/2005 QA70-7543 v8.0212 OCTREE_FIND_NODE_BY_ATTRIBUTE
// DSC 8/26/05 OCTREE_FIND_NODE_BY_ID_AND_REPEAT_ID
// OCTRUT_API BOOL octree_find_node(TreeNode* ptrRoot, TreeNode* ptrReturnNode, LPCSTR lpcszAttribName, int nVal, bool bRecursive = true, int nSearchLevel = 0);
OCTRUT_API BOOL octree_find_node(TreeNode* ptrRoot, TreeNode* ptrReturnNode, LPCSTR lpcszAttribName, int nVal, bool bRecursive = true, int nSearchLevel = 0, int nRepeatID = -1);
// end OCTREE_FIND_NODE_BY_ID_AND_REPEAT_ID
/// end OCTREE_FIND_NODE_BY_ATTRIBUTE

/// EJP 2007-08-09 v8.0768 QA70-10171 FIX_IMG_MISSING_IN_IMG_PREVIEW_DLG
OCTRUT_API BOOL octree_check_node_str_attr(TreeNode* pNode, StringArray *psaAttr, StringArray *psaValue, BOOL bNoCase = FALSE);
OCTRUT_API BOOL octree_check_node_int_attr(TreeNode* pNode, StringArray *psaAttr, IntArray *pnaValue);
OCTRUT_API BOOL octree_find_node_with_str_attr(TreeNode* pRootNode, TreeNode* pReturnNode, StringArray *psaAttr, StringArray *psaValue, BOOL bRecursive = TRUE, int nStartIndex = 0);
OCTRUT_API BOOL octree_find_node_with_int_attr(TreeNode* pRootNode, TreeNode* pReturnNode, StringArray *psaAttr, IntArray *pnaValue, BOOL bRecursive = TRUE, int nStartIndex = 0);
/// end FIX_IMG_MISSING_IN_IMG_PREVIEW_DLG

/// YuI 03/05/09 QA70-13220 WHOLE_WORKSHEET_INPUT_XYRANGE
OCTRUT_API void	octree_composite_range_set_entire_worksheet_support(TreeNode* trInputData, int nVal);
OCTRUT_API int	octree_composite_range_get_entire_worksheet_support(TreeNode* trInputData);
/// end WHOLE_WORKSHEET_INPUT_XYRANGE

// DSC 8/26/05 OCTREE_FIND_NODE_BY_ID_AND_REPEAT_ID
/**
	Example:
	// to get J example node
		TreeNode tr = tree_find_node_by_dataID(trXF, IDV_HELP_EXAMPLE, IDV_HELP_BRANCH, IDRS_HELP_J);
	Return:
		0 = success
		>0 return the nVal that failed to find node
		-1 if one of the nVal = 0 when its parent is not
		
*/
OCTRUT_API int octree_find_node_ex(TreeNode* ptrRoot, TreeNode* ptrReturnNode, LPCSTR lpcszAttribName, int nVal, int nValParent = 0, int nParentRepeatID = -1, int nValGrandParent = 0, int nGrandParentRepeatID = -1);
// OC version
// TreeNode tree_find_node_by_dataID(TreeNode tr, int nVal, int nValParent = 0, int nValGrandParent = 0);
// end OCTREE_FIND_NODE_BY_ID_AND_REPEAT_ID

/// ML 1/13/2006 XVARIABLEBASE_TO_VC
/**$
*/
OCTRUT_API	bool octree_find_node_by_dataID(TreeNode *ptrResult, TreeNode *ptr, int nID, int nIDParent = 0, int nParentRepeatID = -1, int nIDGrandParent = 0, int nGrandParentRepeatID = -1);

//---- CPY 10/4/07 QA70-10463 FIX_NLFIT_LIMIT_20_PARAMETERS
/**$
*/
OCTRUT_API bool octree_check_get_node_by_dataid(TreeNode* ptrParent, TreeNode* ptrNew, LPCSTR lpcszTag, int nDataID=0, LPCSTR lpcszLableAttrib=NULL, LPCSTR lpcszAttribVal=NULL);
//----
/**#
*/
//------ Folger 12/08/08 v8.0983b CHECK_GET_NODE_SHOULD_SUPPORT_CASE_INSENSITIVE
//OCTRUT_API	bool	octree_tree_check_get_node(TreeNode *ptrResult, TreeNode *ptr, LPCSTR lpcszTag, int nID = 0, LPCSTR lpcszAttribName = NULL, LPCSTR lpcszAttribVal = NULL); // = 0 = NULL = NULL
OCTRUT_API	bool	octree_tree_check_get_node(TreeNode *ptrResult, TreeNode *ptr, LPCSTR lpcszTag, int nID = 0, LPCSTR lpcszAttribName = NULL, LPCSTR lpcszAttribVal = NULL, BOOL bCaseSensitive = TRUE); // = 0 = NULL = NULL
//------

///Sophy 10/18/2010 ORG-1277 ADO_DATABASEIMPORT_NEED_GET_NODE_BY_LABEL
/**#
*/
OCTRUT_API	bool	octree_tree_check_get_node_by_attribute(TreeNode* ptrResult, TreeNode* pTr, LPCSTR lpcszAttrName, LPCSTR lpcszAttrValue, BOOL bCaseSensitive = FALSE);
///end ADO_DATABASEIMPORT_NEED_GET_NODE_BY_LABEL

///Sophy 10/25/2010 ORG-1296 MOVE_BUILDDBTREE_TO_VC_FOR_SPEEDUP_NEW_DATABASEIMPORT_DLG
/**#
*/
OCTRUT_API	bool	octree_sort_children_by_int_attribute(TreeNode* pTree, LPCSTR lpcszAttrName, BOOL bAscending = TRUE);
///end MOVE_BUILDDBTREE_TO_VC_FOR_SPEEDUP_NEW_DATABASEIMPORT_DLG

/**$
*/
OCTRUT_API	bool	octree_tree_check_add_input_data_branch(TreeNode *ptrResult, TreeNode *ptrInputData, StringArray *psaKeys, StringArray *psaLabels,
															int nBranchType, int nData = 1, int nType = -1, LPCSTR lpcszDefaultVal = NULL);

/**$
*/
OCTRUT_API	bool octree_set_attributes(TreeNode *ptrDest, const IntArray *pvnAttributeVals, LPCSTR lpcszValToCopy, LPCSTR lpcszDestAttribute = NULL, LPCSTR lpcszAttributeToMatch = NULL, bool bRecursive = true);

//---- CPY 1/29/06 XFBASE_MOVE_OC_TO_VC
/**$
*/
/// Hong 05/26/07 v8.0870 IRIS_REQUIRE_VERSION_NO_RECURSIVE
//OCTRUT_API int octree_count_items_by_attribute(TreeNode *ptr, LPCSTR lpcszAttribute = NULL, LPCSTR lpcszValue = NULL, BOOL bMissingIsMatch = true);
OCTRUT_API int octree_count_items_by_attribute(TreeNode *ptr, LPCSTR lpcszAttribute = NULL, LPCSTR lpcszValue = NULL, BOOL bMissingIsMatch = true, BOOL bRecursive = TRUE);
/// end IRIS_REQUIRE_VERSION_NO_RECURSIVE
OCTRUT_API int octree_remove_nodes_by_attribute(TreeNode *ptr, LPCSTR lpcszAttribute, int nAttribVal);
//----
/// end XVARIABLEBASE_TO_VC

//// AW 04/03/07 QA80-9548 v8.0597 XF_LOCALIZATION
OCTRUT_API BOOL octree_get_help_node(TreeNode* trHelp, TreeNode* trXF, int nNodeID = IDV_HELP_SUMMARY, int nLanguage = IDRS_HELP_E); 

OCTRUT_API BOOL octree_get_localization_node(TreeNode* ptrOut /*output*/, TreeNode *ptrParent /*input*/, int nHelpDataId, int nDefaultId, int nHelpBranchId,
											BOOL bChkEmpty = TRUE , int nLang =  -1);
//// END XF_LOCALIZATION

 
///Forest 3/30/05 QA70-7456 COPY_TREE_BY_FILTER
//OC_API BOOL octree_copy_by_filter(TreeNode* trDest, TreeNode* trSrc, int nUnitNodeID, int nIncludeMode, int nIncludeNodeID, StringArray* pIncludeValues, int nExcludeMode, int nExcludeNodeID, StringArray* pExcludeValues);///Forest 4/1/05 QA70-7456 AVOID_CLONE_OF_TREE
OCTRUT_API BOOL octree_filter(TreeNode* trSrc, int nUnitNodeID, int nIncludeMode, int nIncludeNodeID, StringArray* pIncludeValues, int nExcludeMode, int nExcludeNodeID, StringArray* pExcludeValues);
///End COPY_TREE_BY_FILTER

///Forest 4/2/05 TREE_FILTER_BY_ATTRIB_MATCH
OCTRUT_API BOOL octree_filter_by_attrib_find(TreeNode* ptr, int iUnitNodeID, LPCSTR lpcstrAttrib, LPCSTR lpcstrSub, BOOL bCaseSensitive = FALSE, BOOL bMustBeginWith = FALSE);
OCTRUT_API BOOL	octree_filter_by_attrib_match(TreeNode* ptr, int iUnitNodeID, LPCSTR lpcstrAttrib, LPCSTR lpcstrPattern, BOOL bCaseSensitive = FALSE);
///End TREE_FILTER_BY_ATTRIB_MATCH

OCTRUT_API BOOL octree_set_date_node(TreeNode* ptr, double dJulianDate);   //---- CPY QA70-8636 4/26/06 EXTERNAL_LINK_INFO_DISPLAY_IN_TOP_LEFT_CORNER


///====================================
//------ Hong 08/04/06 THEME_TREE_GET_NODE_BY_INDEX
//------ Hong 08/04/06 THEME_TREE_GET_NODE_BY_ID	
OCTRUT_API BOOL octree_theme_tree_get_node_by_id(TreeNode* ptrN, TreeNode* ptrRoot, int nID, int nStopLevel = -1, bool bRecursive = false);	
//------ Folger 07/27/07 UPDATE_USAGE_OF_OCTREE_THEME_TREE_GET_NODE_BY_INDEX
/*
	Remarks: 
		Find treenode firstly by ID, then by Index
	Example1: 
		void test_get_theme_treenode()
		{
			Worksheet wks = Project.ActiveLayer();
			Tree trFmt;
			trFmt = wks.GetFormat(FPB_ALL, FOB_ALL & ~(FOB_LINK_STYLE|FOB_RANGE_STYLE), TRUE, TRUE);
			TreeNode trProp;
			TreeNode trNameStyles;
			int nIndex = 2;
			int nStopLevel = 3;
			bool bRet = octree_theme_tree_get_node_by_index(&trNameStyles, &trFmt, OTID_NAMESTYLES, 2, 3, true);
			bRet = octree_theme_tree_get_node_by_id(&trProp, &trNameStyles, OTID_NAMESTYLE_NAME, 3, true);			
			out_tree(trProp);
		}
	Parameters: 
		ptrN = [output]result treenode
		ptrRoot = [input]source treenode that searched from
		nID = [input]theme ID
		nIndex = [input]childnode index of treenode with nID
		nStopLevel = [input]recursive level, default -1
		bRecursive = [input]recursive or not, default false
		Return: 
			TRUE if target treenode found, otherwise false
*/
//------ End UPDATE_USAGE_OF_OCTREE_THEME_TREE_GET_NODE_BY_INDEX
OCTRUT_API BOOL octree_theme_tree_get_node_by_index(TreeNode* ptrN, TreeNode* ptrRoot, int nID, int nIndex, int nStopLevel = -1, bool bRecursive = false);
OCTRUT_API BOOL octree_theme_tree_get_range_from_range_style(TreeNode* trRange, int* pLeft, int* pTop, int* pRight, int*pBottom);

//------ End THEME_TREE_GET_NODE_BY_INDEX

///Hong 7/26/06 MOVE_OC_TO_VC
OCTRUT_API void octree_set_attribute_to_all_nodes(TreeNode* tr, LPCSTR lpcszAttrib, LPCSTR lpcszAttribVal, bool b1stLevelChildrenOnly = false, bool bBranchOnly = false);
OCTRUT_API int octree_set_values_by_nodeids(TreeNode* trSetting, IntArray* vnNodeIDs, StringArray* vsValues);
/// Hong 06/18/07 v8.0643 FIX_XF_SHOW_HELP_BY_LT_ERROR_SHOW_HIDDEN_NODE
//OCTRUT_API int octree_hide_empty_nodes(TreeNode* tr, bool bRecursive = true);
OCTRUT_API int octree_hide_empty_nodes(TreeNode* tr, bool bRecursive = true, bool bRemoveShowAttrib = true);
/// end FIX_XF_SHOW_HELP_BY_LT_ERROR_SHOW_HIDDEN_NODE
OCTRUT_API BOOL octree_set_attribute_bit_if_not_empty(TreeNode* tr, LPCSTR lpcszAttribute, DWORD dwBit, bool bRecursive = true);
OCTRUT_API BOOL octree_node_copy_attribute(TreeNode* trSrc, TreeNode* trDest, LPCSTR lpcszAttribute);
OCTRUT_API string octree_get_node_label(TreeNode *tr, bool bGetLabelFirst = true);

/// YuI 08/08/06
//OCTRUT_API int octree_remove_attribute(TreeNode *tr, LPCSTR lpcszAttribute);
OCTRUT_API int octree_remove_attribute(TreeNode *tr, LPCSTR lpcszAttribute, BOOL bRemoveAtTopLevel = FALSE);
/// end YuI 08/08/06

OCTRUT_API BOOL octree_get_node_names(TreeNode *tr, StringArray *vs, bool bSubNodeOnly = false);
OCTRUT_API void octree_clear_all_value(TreeNode *tr);
OCTRUT_API BOOL octree_get_node_by_id(TreeNode *tr, TreeNode *trOut, int nID, bool bRecursive = false);
OCTRUT_API BOOL octree_branch_to_key_value_pairs_str(TreeNode *tr, string* pstrMultiline, char cKVSep = '=', char cLineSep = '\n'); //CPY 7/19/06 FIX_BAD_DEFAULT_STR
OCTRUT_API BOOL octree_key_value_pairs_str_to_branch(TreeNode *tr, LPCSTR lpcszMultiline, char cKVSep = '=', char cLineSep = '\n');
OCTRUT_API bool octree_tree_read_values_with_ids(LPCSTR lpcszFullFilename, IntArray* pocvnIDs, StringArray* pocvsValues, string* lpcszTreeNodeComment = NULL );
OCTRUT_API int octree_GETN_reset_hidden_values(TreeNode *tr, IntArray *pvnDataIDsToReset, bool bRecursive = true );
OCTRUT_API void octree_get_enum_node_name(TreeNode *trNode, string *strOut, LPCSTR strPrefix);
///Hong 8/01/06 ADD_POSTFIX_SUPPORT

//------ Folger 12/28/07 TREE_TAGNAME_OPERATION_MOVE_TO_VC
OCTRUT_API bool	octree_get_node_by_tagname(TreeNode *ptr, TreeNode *ptrReturn, LPCSTR lpcszTagName, bool bRecursive = false, bool bCaseSensitive = false, bool bSkipBranch = false);
OCTRUT_API int	octree_copy_ids_by_tagname(TreeNode *ptrSrc, TreeNode *ptrDest, bool bSkipBranch = false);
//------

 ///Joseph 03/26/07 THEME_ADD_THEMETREE_FILE_GETNTREE_CONVERT_FUNCTION
OCTRUT_API bool octree_get_theme(TreeNode* trTheme, IntArray* vnIDs, StringArray* vsValues, string* strCommment);

OCTRUT_API bool octree_set_theme(TreeNode* trTheme, IntArray* vnIDs, StringArray* vsValues, LPCSTR strCommment);
///End 	THEME_ADD_THEMETREE_FILE_GETNTREE_CONVERT_FUNCTION

/// AW 01/29/07 QA80-9310 v8.0550b AUTO_RECOGNITION_FOR_INDEX_RAW_DATA_IN_STATS_TOOL
OCTRUT_API BOOL	 octree_get_root_node(TreeNode* ptr, TreeNode* ptrRoot);
/// END AUTO_RECOGNITION_FOR_INDEX_RAW_DATA_IN_STATS_TOOL

//OCTRUT_API void octree_get_enum_attribute_value(TreeNode *trNode, string *strOut, LPCSTR strAttribute, LPCSTR strPrefix);
OCTRUT_API void octree_get_enum_attribute_value(TreeNode *trNode, string *strOut, LPCSTR strAttribute, LPCSTR strPrefix, LPCSTR strPostfix = "");
///end ADD_POSTFIX_SUPPORT 
OCTRUT_API int octree_append_children(TreeNode *tr1, TreeNode *tr2, LPCSTR lpcszPrefix);
///Kyle 04/09/2009 QA80-13425 WANT_REPORTDATA_SUPPORT_USING_DEFAULT_ENUMERATION_FOR_SHORTNAME
//OCTRUT_API int octree_get_next_enum_tag_name(TreeNode *tr, string *strTag = NULL);
OCTRUT_API int octree_get_next_enum_tag_name(TreeNode *tr, string *strTag = NULL, BOOL bUseNumbers = TRUE);
///End WANT_REPORTDATA_SUPPORT_USING_DEFAULT_ENUMERATION_FOR_SHORTNAME
OCTRUT_API int octree_move_node(TreeNode *tr, int nRow, int nPosition = -1, DWORD dwCntrl = 0, LPCSTR lpcszAttribute = NULL);
OCTRUT_API BOOL	octree_is_in_ids_range(TreeNode *trNode, int nBeginID, int nEndID, int nOffset = 0);
/// TD 4-12-06 VC_FUNCTIONS_TO_LAUNCH_XFN_GETN
OCTRUT_API int octree_tree_get_theme_type(TreeNode* tr);
OCTRUT_API bool octree_tree_get_theme_file_name(TreeNode *tr, string *pstrThemeFileName);
OCTRUT_API bool octree_tree_set_theme_file_name(TreeNode *tr, LPCSTR lpcszThemeFileName);
/// TD 5-4-07 QA80-9724 THEME_TREE_WITH_LABELS_FOR_READABILITY
//OCTRUT_API bool octree_tree_save_values_with_ids(LPCSTR lpcszFullFilename, IntArray* pocvnIDs, StringArray* pocvsValues, LPCSTR lpcszTreeNodeComment );
OCTRUT_API bool octree_tree_save_values_with_ids(LPCSTR lpcszFullFilename, IntArray* pocvnIDs, StringArray* pocvsValues, LPCSTR lpcszTreeNodeComment, StringArray* pocvsLabels = NULL );
/// end THEME_TREE_WITH_LABELS_FOR_READABILITY
/// end VC_FUNCTIONS_TO_LAUNCH_XFN_GETN
///end MOVE_OC_TO_VC

//------ Folger 03/03/08 QA80-11192 LOAD_DEFAULT_THEME_BEFORE_RESET_TO_FACTORY_DEFAULT
OCTRUT_API	bool	octree_save_values_with_ids(TreeNode *ptrDes, IntArray* pocvnIDs, StringArray* pocvsValues, LPCSTR lpcszTreeNodeComment, StringArray* pocvsLabels = NULL );
//------

/// YuI 01/09/07 QA70-8806 AUTO_SUPPORT_FOR_XF_VARIABLES
//---- CPY 4/21/07 SET_AUTO_SHOULD_USE_DEFAULT
//OCTRUT_API void octree_set_auto_support(TreeNode* tr, int nVal);
// nVal = 1 - supported, checked
// nVal = -1 - supported, uncheked
// nVal = 0 - remove auto support
OCTRUT_API void octree_set_auto_support(TreeNode* tr, int nVal = 1);
//----
OCTRUT_API int octree_get_auto_support(TreeNode* tr);
/// end AUTO_SUPPORT_FOR_XF_VARIABLES

/// ML 1/17/2007 PUTTING_TAGNAMES_PATH_INTO_ATTRIBUTES
OCTRUT_API	BOOL	octree_add_path_str(TreeNode* ptr, LPCSTR lpcszAttribName, BOOL bRecursive = TRUE, BOOL bIncludeRoot = FALSE);
/// end PUTTING_TAGNAMES_PATH_INTO_ATTRIBUTES

///Cheney 2007-1-30 MOVE_SOME_FUNCTION_FOR_NLFIT_REPORT_TO_VC
OCTRUT_API BOOL	report_get_set_data_string(string* str, int nIndexSet, int nNumSets = 1);
OCTRUT_API void	report_get_escaped_data_string(string* str, int nIndexLT, BOOL bSubRange = FALSE, char cType = 'A', char cXYW = 0, int nAddtional = ESC_LABEL_ADD_NONE, char chDataFactSubj = 0, int nSecondNum = 0);
///------ Folger 03/24/09 QA80-13331-P1 CUSTOMIZED_OUTPUT_COLUMN_LONGNAME_FORMAT_SUPPORT
OCTRUT_API BOOL	report_set_escaped_data_string_type(string* str, char cType);
///------ End CUSTOMIZED_OUTPUT_COLUMN_LONGNAME_FORMAT_SUPPORT
/// ML 4/25/2008 NL_SURFACE_FIT_INPUT_DATA_TABLE_WITH_WEIGHTS
//OCTRUT_API TreeNode	report_make_input_data_table_var_row(TreeNode* trInputTable, int indexSet, int iWithinSet, int iWithinDepOrIndep, bool bDep, LPCSTR lpcszVarName, int numData, int nDataIndex, int nTotalPerSet, int nNumDataSet, int nWeightMethod, TreeNode* trrABC);
//OCTRUT_API void	report_update_input_data_table(TreeNode* trInputTable, int index, int numData, int nDeps, int nIndeps, StringArray* vsDepVarNames, StringArray* vsIndepVarNames, int nNumDataSet, int nWeightMethod, TreeNode* trrABC);
///------ Folger 08/17/10 ORG-824-P1 WEIGHTING_BROKEN_FOR_MULTIPLE_DEPS_FITTING
//OCTRUT_API TreeNode	report_make_input_data_table_var_row(TreeNode* trInputTable, int indexSet, int iWithinSet, int iWithinDepOrIndep, bool bDep, LPCSTR lpcszVarName, int numData, int nDataIndex, int nTotalPerSet, int nNumDataSet, int nWeightMethod, TreeNode* trrABC, BOOL bXYZ = FALSE);
//OCTRUT_API void	report_update_input_data_table(TreeNode* trInputTable, int index, int numData, int nDeps, int nIndeps, StringArray* vsDepVarNames, StringArray* vsIndepVarNames, int nNumDataSet, int nWeightMethod, TreeNode* trrABC, BOOL bXYZ = FALSE);
OCTRUT_API TreeNode	report_make_input_data_table_var_row(TreeNode* trInputTable, int indexSet, int iWithinSet, int iWithinDepOrIndep, bool bDep, LPCSTR lpcszVarName, int numData, int nDataIndex, int nTotalPerSet, int nNumDataSet, int nWeightMethod, TreeNode* trrABC, BOOL bXYZ = FALSE, int nDepAcrossSet = -1);
OCTRUT_API void	report_update_input_data_table(TreeNode* trInputTable, int index, int numData, int nDeps, int nIndeps, StringArray* vsDepVarNames, StringArray* vsIndepVarNames, int nNumDataSet, IntArray* pvnWeights, TreeNode* trrABC, BOOL bXYZ = FALSE);
///------ End WEIGHTING_BROKEN_FOR_MULTIPLE_DEPS_FITTING
/// end NL_SURFACE_FIT_INPUT_DATA_TABLE_WITH_WEIGHTS
///end MOVE_SOME_FUNCTION_FOR_NLFIT_REPORT_TO_VC

///Cheney 2007-3-7 MOVE_SOME_FUNCTION_TO_VC_FOR_IMPROVE_SPEED_FOR_STATS_ON_COLUMNS
/*
OCTRUT_API BOOL	report_get_combined_string(string* str, DWORD dwCombined);
OCTRUT_API string report_get_picture_tag_name(int nPictureIndex, bool bIsRow = TRUE);
OCTRUT_API void	report_check_create_all_imag_subnodes(TreeNode* ptrGraph, TreeNode* ptrOp, TreeNode* ptrPict, DWORD dwtrOpRules, int nGraphIndex, int nNumPicRows, int nNumPicCols, int nReportGraphTableCols, int nPictureForOneGraphType, bool bPlotAllPlotsInOneGraph);
OCTRUT_API int	report_get_data_source_plot_type(int nGraphIndex = 0);
OCTRUT_API void	report_update_all_image_node_plotting_info(TreeNode* ptrOp, TreeNode* ptrPlotInfo, int nGraphIndex, int nNumPicRows, int nNumPicCols, int nReportGraphTableCols, int nPictureForOneGraphType);
OCTRUT_API string report_op_get_graph_tag_name(int nIndex = 0);
OCTRUT_API TreeNode	report_check_get_plot_info_node(TreeNode* ptrOp, int nGraphIndex, int nPictureRowIndex, int nPicColIndex = 0, int nPlotIndex = 0, bool bCreate = TRUE);
*/
///end MOVE_SOME_FUNCTION_TO_VC_FOR_IMPROVE_SPEED_FOR_STATS_ON_COLUMNS

/// Hong 06/26/07 v8.0649 TREE_GET_ROW_NUMBER_IN_SPLITTER
/**
	Example:
		void octree_get_row_number_ex()
		{
			Tree tr;
			tr.one.one2.one3.nVal = 10;
			
			tr.two.two2.strVal = "target";
			
			tr.three.nVal = 3;
			
			int nn = octree_get_row_number(&tr, "originstorage.two.two2");
			
			out_int("", nn);
		}
	Return:
		the row number of the target treenode in ptr, -1 if fail to find the taget treenode
		
*/
OCTRUT_API	int	octree_get_row_number(TreeNode* ptr, LPCSTR lpcszPath);
/// end TREE_GET_ROW_NUMBER_IN_SPLITTER
/// TD 01-08-2009 QA80-12937 LT_DRIVEN_XFUNCTIONS
OCTRUT_API	int octree_get_level(string* pstrPathOut, TreeNode *ptrNode, TreeNode *ptrNodeRoot, BOOL bCheckEventRoot);
/// end LT_DRIVEN_XFUNCTIONS

/// RVD 10/4/2007 v8.0715 qa7-10463 FIX_NLFIT_LIMIT_20_PARAMETERS
#ifdef	NLSF_PARAM_TREE_CONSRUCTION_MOVE_VC

OCTRUT_API void	octree_nlsf_add_params_node_DataID(TreeNode* ptr, int nParamSize);
OCTRUT_API bool	octree_nlf_set_bool_param_from_user_params_setting(TreeNode* ptrParams, BoolArray* pbvParams, int nDataFrom);
OCTRUT_API bool	octree_nlf_set_double_param_from_user_params_setting(TreeNode* ptrParams, DoubleArray* pdvParams, int nDataFrom);
OCTRUT_API bool	octree_nlf_set_int_param_from_user_params_setting(TreeNode* ptrParams, IntArray* pdvParams, int nDataFrom); /// Hong 10/17/07 v8.0727b JASMINE_ASK_FOR_INT_ARRAY
/// Hong 01/17/08 QA80-10937 FIX_THEME_APPLY_SHOULD_DUPLIACTE_LAST_DATASET
//OCTRUT_API void	octree_value_from_tree_sub_nodes_to_vector_double(TreeNode* ptr, DoubleArray* pdv);
//OCTRUT_API void	octree_value_from_tree_sub_nodes_to_vector_int(TreeNode* ptr, IntArray* piv);
//OCTRUT_API void	octree_value_from_tree_sub_nodes_to_vector_bool(TreeNode* ptr, BoolArray* pbv);
OCTRUT_API int	octree_value_from_tree_sub_nodes_to_vector_double(TreeNode* ptr, DoubleArray* pdv);
OCTRUT_API int	octree_value_from_tree_sub_nodes_to_vector_int(TreeNode* ptr, IntArray* piv);
OCTRUT_API int	octree_value_from_tree_sub_nodes_to_vector_bool(TreeNode* ptr, BoolArray* pbv);
/// end FIX_THEME_APPLY_SHOULD_DUPLIACTE_LAST_DATASET
OCTRUT_API void	octree_value_from_vec_double_to_tree_sub_nodes(DoubleArray* pdv, TreeNode* ptr);
OCTRUT_API void	octree_value_from_vec_int_to_tree_sub_nodes(IntArray* piv, TreeNode* ptr);
OCTRUT_API void	octree_value_from_vec_bool_to_tree_sub_nodes(BoolArray* pbv, TreeNode* ptr);

#endif	//NLSF_PARAM_TREE_CONSRUCTION_MOVE_VC
/// end FIX_NLFIT_LIMIT_20_PARAMETERS

/// YuI 12/21/07 QA7-10854 MOVE_HISTOGRAM_TO_VC
OCTRUT_API BOOL	octree_stats_get_boxchart_box_node(TreeNode* ptrStats, TreeNode* ptrBoxNode);
OCTRUT_API BOOL	octree_stats_get_boxchart_whisker_node(TreeNode* ptrStats, TreeNode* ptrWhiskerNode);
OCTRUT_API void	octree_stats_get_set_stats_results(TreeNode* ptrStats, DescStatResults* pdsr, double* pdMin, double* pdMax, BOOL bGet = TRUE);
OCTRUT_API void	octree_stats_get_set_counts(TreeNode* ptrStats, DoubleArray* pvCounts, BOOL bGet = TRUE);
OCTRUT_API void	octree_stats_get_set_percentiles(TreeNode* ptrStats, DoubleArray* pvPercentiles, BOOL bGet = TRUE);
OCTRUT_API void	octree_stats_get_set_bin_info(TreeNode* ptrStats, double* pdMin, double* pdMax, double* pdSize, BOOL bGet = TRUE);

/// YuI 12/18/08 QA70-12800 PD_DIALOG_TO_CONTROL_HISTOGRAM_CREATED_BY_OPERATION
OCTRUT_API BOOL octree_stats_is_bin_auto(TreeNode* ptrStats);
OCTRUT_API void octree_stats_set_bin_auto(TreeNode* ptrStats, BOOL bOn = TRUE);
/// end PD_DIALOG_TO_CONTROL_HISTOGRAM_CREATED_BY_OPERATION

OCTRUT_API void	octree_stats_get_set_box_info(TreeNode* ptrStats, double* pdTop, double* pdTopX, double* pdBottom, double* pdBottomX, double* pdCenter, BOOL bGet = TRUE);
OCTRUT_API void	octree_stats_get_set_whisker_info(TreeNode* ptrStats, double* pdTop, double* pdBottom, BOOL bGet = TRUE);
/// end MOVE_HISTOGRAM_TO_VC

/// Iris 8/31/2009 QA80-14209 IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED
OCTRUT_API void	octree_check_add_enumerated_node(TreeNode* ptr, TreeNode* ptrParent, LPCTSTR lpcszPrefix, int index, int nID = -1, LPCSTR lpcszAttrib = NULL, LPCSTR lpcszAttribVal = NULL);
OCTRUT_API int	octree_make_one_set_ID(int idBase, int nDataIndex);
OCTRUT_API bool octree_check_add_all_enumerated_nodes(TreeNode* ptrParent, LPCSTR lpcszPrefix, DoubleArray* pvData, int nBaseID, LPCSTR lpcszRowLabel, int* pRowStart = NULL, int* pnMax = NULL);
///end IMPROVE_CREATE_MASKED_MISSING_DATA_TABLE_SPEED

//----- CPY 12/1/2007 QA70-10765 DEFAULT_CODE_PAGE_CONTROL
// returns old value
OCTRUT_API int octree_set_default_code_page(int ncp);
#ifndef __AFX_H__
class XMLStrCodePage
{
public:
	XMLStrCodePage(int ncp)
	{
		m_nOldValue = octree_set_default_code_page(ncp);
	}
	~XMLStrCodePage()
	{
		octree_set_default_code_page(m_nOldValue);
	}
private:
	int m_nOldValue;
};
#endif//!__AFX_H__
//-----


#ifdef __AFX_H__
	}
#endif	//__AFX_H__

#endif //_OCTREEUTILS_H
